#include <windows.h>
#include <sstream>
#include <cstring>
#include <cstdlib>
#include <ctime>
#include <fstream>
#include "resursID.h"
using namespace std;

const char KlassNamn[]="Minklass";
int CollisionDetection(RECT* prc,HWND hwnd);
void Draw(HDC hdc,RECT* prc);
void UpdateBall();
void UpdateComputer(int i);

bool UpDown=false;
bool DownDown=false;
bool WDown=false;
bool SDown=false;
bool AutoPilot=false;
bool mate=false;
bool Pause=false;

HFONT g_hfFont;

int padd1score,padd2score;

const int ID_TIMER=1;

struct PADDEL
{
       int x,y;
       int width;
       int height;
       int speed;
       HBITMAP biten;
};
struct BALL
{
       int x,y;
       int dx,dy;
       int speed;
       int width,height;
       HBITMAP biten;
       HBITMAP masken;
};
PADDEL paddel[2];
BALL boll;
HBITMAP bakgrund;
int speedoptions;     //0=boll, 1=paddel1, 2=paddel2

BOOL CALLBACK NumbDlgProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam) {
     switch(message) {
                     case WM_INITDIALOG:
                          if(speedoptions==0)
                          SetDlgItemText(hwnd,IDD_TEXT,"Skriv in bollens hastighet:");
                          else if(speedoptions==1)
                          SetDlgItemText(hwnd,IDD_TEXT,"Skriv in paddel 1's hastighet:");
                          else if(speedoptions==2)
                          SetDlgItemText(hwnd,IDD_TEXT,"Skriv in paddel 2's hastighet:");
                     break;
                     
                     case WM_COMMAND:
                          switch(LOWORD(wParam)) {
                                                 case IDOK:
                                                      {
                                                      int nummer=GetDlgItemInt(hwnd,IDD_NUMBER,NULL,FALSE);
                                                      if(nummer>0) {
                                                      if(speedoptions==0)
                                                      boll.speed=nummer;
                                                      else if(speedoptions==1)
                                                      paddel[0].speed=nummer;
                                                      else if(speedoptions==2)
                                                      paddel[1].speed=nummer;
                                                      Pause=false;
                                                      EndDialog(hwnd,IDOK);
                                                      }
                                                      }
                                                 break;
                          }
                     break;
                     default:
                             return FALSE;
     }
     return TRUE;
}

LRESULT CALLBACK WndProc(HWND hwnd,UINT msg,WPARAM wParam, LPARAM lParam) {
        switch(msg) {
                    case WM_CREATE:
                         {
                                   srand(time(0));
                                   MoveWindow(hwnd,300,200,600,450,TRUE);
                                   BITMAP bm;
                                   RECT prc;
                                   GetClientRect(hwnd,&prc);
                                   paddel[0].biten=LoadBitmap(GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_PADDEL));
                                   paddel[1].biten=LoadBitmap(GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_PADDEL));
                                   GetObject(paddel[0].biten,sizeof(bm),&bm);
                                   paddel[0].width=bm.bmWidth;
                                   paddel[1].width=bm.bmWidth;
                                   paddel[0].height=bm.bmHeight;
                                   paddel[1].height=bm.bmHeight;
                                   boll.biten=LoadBitmap(GetModuleHandle(NULL),MAKEINTRESOURCE(IDB_BALL));
                                   boll.masken=LoadBitmap(GetModuleHandle(NULL),MAKEINTRESOURCE(IDB_BALLM));
                                   GetObject(boll.biten,sizeof(bm),&bm);
                                   boll.width=bm.bmWidth;
                                   boll.height=bm.bmHeight;
                                   bakgrund=LoadBitmap(GetModuleHandle(NULL),MAKEINTRESOURCE(IDB_BACK));
                                   paddel[0].y=prc.bottom/2;
                                   paddel[1].y=prc.bottom/2;
                                   paddel[0].x=40;
                                   paddel[1].x=prc.right-paddel[1].width-40;
                                   paddel[0].speed=6;
                                   paddel[1].speed=6;
                                   boll.speed=6;
                                   SetTimer(hwnd,ID_TIMER,40,NULL);
                                   boll.x=prc.right/2;
                                   boll.y=prc.bottom/2;
                                   if(rand()%2==1)
                                   boll.dy=boll.speed;
                                   else
                                   boll.dy=-boll.speed;
                                   if(rand()%2==1)
                                   boll.dx=boll.speed;
                                   else
                                   boll.dx=-boll.speed;
                                   padd1score=0;
                                   padd2score=0;
                                   AutoPilot=true;
                                   
                                   HFONT hf;
                                   HDC hdc;
                                   long lfHeight;
                                   
                                   hdc=GetDC(NULL);
                                   lfHeight=-MulDiv(12,GetDeviceCaps(hdc, LOGPIXELSY), 72);
                                   ReleaseDC(NULL,hdc);
                                   
                                   hf=CreateFont(lfHeight,0,0,0,0,TRUE,0,0,0,0,0,0,0,"Times New Roman");
                                   if(hf) {
                                          DeleteObject(g_hfFont);
                                          g_hfFont=hf;
                                   }
                         }
                    break;
                    case WM_TIMER:
                         {
                                  if(Pause==false) {
                                  RECT rcClient;
                                  HDC hdc = GetDC(hwnd);
                                  GetClientRect(hwnd,&rcClient);
                                  if(mate==false)
                                  UpdateComputer(1);
                                  else if(mate==true) {
                                  if(WDown==true)
                                  paddel[1].y-=paddel[1].speed;
                                  if(SDown==true)
                                  paddel[1].y+=paddel[1].speed;
                                  }
                                  if(AutoPilot==true)
                                  UpdateComputer(0);
                                  else if(AutoPilot==false) {
                                  if(UpDown==true)
                                  paddel[0].y-=paddel[0].speed;
                                  if(DownDown==true)
                                  paddel[0].y+=paddel[0].speed;
                                  }
                                  UpdateBall();
                                  CollisionDetection(&rcClient,hwnd);
                                  Draw(hdc,&rcClient);
                                  ReleaseDC(hwnd,hdc);
                                  }
                         }
                    break;
                    case WM_COMMAND:
                         switch(LOWORD(wParam)) {
                                                case IDM_BALLSPEED:
                                                     speedoptions=0;
                                                     UpDown=false;
                                                     DownDown=false;
                                                     Pause=true;
                                                     DialogBox(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_NAME),hwnd, NumbDlgProc);
                                                break;
                                                case IDM_PADD1SPEED:
                                                     speedoptions=1;
                                                     UpDown=false;
                                                     DownDown=false;
                                                     Pause=true;
                                                     DialogBox(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_NAME),hwnd, NumbDlgProc);
                                                break;
                                                case IDM_PADD2SPEED:
                                                     speedoptions=2;
                                                     UpDown=false;
                                                     DownDown=false;
                                                     Pause=true;
                                                     DialogBox(GetModuleHandle(NULL),MAKEINTRESOURCE(IDD_NAME),hwnd, NumbDlgProc);
                                                break;
                                                case IDM_MATE:
                                                     if(mate==false)
                                                     mate=true;
                                                     else if(mate==true)
                                                     mate=false;
                                                break;
                                                case IDM_NEW:
                                                     {
                                                     RECT prc;
                                                     GetClientRect(hwnd,&prc);
                                                     paddel[0].y=prc.bottom/2;
                                                     paddel[1].y=prc.bottom/2;
                                                     paddel[0].x=40;
                                                     paddel[1].x=prc.right-paddel[1].width-40;
                                                     boll.x=prc.right/2;
                                                     boll.y=prc.bottom/2;
                                                     if(rand()%2==1)
                                                     boll.dy=boll.speed;
                                                     else
                                                     boll.dy=-boll.speed;
                                                     if(rand()%2==1)
                                                     boll.dx=boll.speed;
                                                     else
                                                     boll.dx=-boll.speed;
                                                     padd1score=0;
                                                     padd2score=0;
                                                     AutoPilot=false;
                                                     Sleep(2000);
                                                     }
                                                break;
                         }
                    break;
                    case WM_PAINT:
                         {
                         PAINTSTRUCT ps;
                             RECT rcClient;
                             GetClientRect(hwnd,&rcClient);
                             HDC hdc = BeginPaint(hwnd,&ps);
                             Draw(hdc,&rcClient);
                             EndPaint(hwnd,&ps);
                         }
                    break;
                    case WM_KEYDOWN:
                         switch(wParam) {
                                                case VK_UP:
                                                     UpDown=true;
                                                break;
                                                case VK_DOWN:
                                                     DownDown=true;
                                                break;
                                                case VK_NUMPAD8:
                                                     WDown=true;
                                                break;
                                                case VK_NUMPAD2:
                                                     SDown=true;
                                                break;
                         }
                    break;
                    case WM_KEYUP:
                         switch(wParam) {
                                                case VK_UP:
                                                     UpDown=false;
                                                break;
                                                case VK_DOWN:
                                                     DownDown=false;
                                                break;
                                                case VK_NUMPAD8:
                                                     WDown=false;
                                                break;
                                                case VK_NUMPAD2:
                                                     SDown=false;
                                                break;
                         }
                    break;
                    case WM_CLOSE:
                         DestroyWindow(hwnd);
                    break;
                    case WM_DESTROY:
                         PostQuitMessage(0);
                    break;
                    default:
                            return DefWindowProc(hwnd,msg,wParam,lParam);
        }
        return 0;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {
    WNDCLASSEX wc;
    HWND hwnd;
    MSG Msg;
    
    wc.cbSize		 = sizeof(WNDCLASSEX);
	wc.style		 = 0;
	wc.lpfnWndProc	 = WndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInstance;
	wc.hIcon		 = LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(ID_MYICON));
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
	wc.lpszMenuName  = MAKEINTRESOURCE(IDM_MENU);
	wc.lpszClassName = KlassNamn;
	wc.hIconSm		 = LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(ID_SMICON));

	if(!RegisterClassEx(&wc))
	{
		MessageBox(NULL, "Window Registration Failed!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return 0;
	}

	hwnd = CreateWindowEx(
		WS_EX_CLIENTEDGE,
		KlassNamn,
		"Pong",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, 240, 120,
		NULL, NULL, hInstance, NULL);

	if(hwnd == NULL)
	{
		MessageBox(NULL, "Window Creation Failed!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return 0;
	}

	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	while(GetMessage(&Msg, NULL, 0, 0) > 0)
	{
		TranslateMessage(&Msg);
		DispatchMessage(&Msg);
	}
	return Msg.wParam;
}

int CollisionDetection(RECT* prc,HWND hwnd) {
     bool collision=true;
     
     int left1, left2;
    int right1, right2;
    int top1, top2;
    int bottom1, bottom2;
    
for(int i=0; i<2; i++) {
        collision=true;
    left1 = paddel[i].x;
    left2 = boll.x;
    right1 = paddel[i].x + paddel[i].width;
    right2 = boll.x + boll.width;
    top1 = paddel[i].y;
    top2 = boll.y;
    bottom1 = paddel[i].y + paddel[i].height;
    bottom2 = boll.y + boll.height;

    if (bottom1 < top2) collision=false;
    if (top1 > bottom2) collision=false;

    if (right1 < left2) collision=false;
    if (left1 > right2) collision=false;
    
    if(collision==true) {
    if(i==0)
    padd1score+=paddel[1].speed;
    else if(i==1)
    padd2score+=paddel[0].speed;
    
    if(boll.x<=paddel[i].x+paddel[i].width)
    boll.dx=boll.speed;
    if(boll.x<=paddel[i].x)
    boll.dx=-boll.speed;
    if(paddel[i].y<0)
    paddel[i].y=0;
    else if(paddel[i].y-paddel[i].height > prc->bottom)
    paddel[i].y=prc->bottom-paddel[i].height;
    int BollPos=boll.y-paddel[i].y+(boll.height/2)-(paddel[i].height/2);
    if(BollPos>5) {
    double temp=BollPos;
    temp-=temp*0.50;
    BollPos=int(temp);
    }
    else if(BollPos<-5) {
    double temp=BollPos;
    temp-=temp*0.50;
    BollPos=int(temp);
    }
    if(BollPos>20)
    BollPos=20;
    else if(BollPos<-20)
    BollPos=-20;
    boll.dy=BollPos;
    }
if(paddel[i].y<0)
paddel[i].y=0;
else if(paddel[i].y+paddel[i].height > prc->bottom)
paddel[i].y=prc->bottom-paddel[i].height;
}
if(boll.y<0) {
boll.y=0;
boll.dy=-boll.dy;
}
else if(boll.y+boll.height>prc->bottom) {
boll.y=prc->bottom-boll.height;
boll.dy=-boll.dy;
}
if(boll.x<0) {
padd2score+=10;
RECT prc;
GetClientRect(hwnd,&prc);
paddel[0].y=prc.bottom/2;
paddel[1].y=prc.bottom/2;
paddel[0].x=40;
paddel[1].x=prc.right-paddel[1].width-40;
boll.x=prc.right/2;
boll.y=prc.bottom/2;
if(rand()%2==1)
boll.dy=boll.speed;
else
boll.dy=-boll.speed;
if(rand()%2==1)
boll.dx=boll.speed;
else
boll.dx=-boll.speed;
Sleep(1500);
}
else if(boll.x+boll.width>prc->right) {
padd1score+=10;
RECT prc;
GetClientRect(hwnd,&prc);
paddel[0].y=prc.bottom/2;
paddel[1].y=prc.bottom/2;
paddel[0].x=40;
paddel[1].x=prc.right-paddel[1].width-40;
boll.x=prc.right/2;
boll.y=prc.bottom/2;
if(rand()%2==1)
boll.dy=boll.speed;
else
boll.dy=-boll.speed;
if(rand()%2==1)
boll.dx=boll.speed;
else
boll.dx=-boll.speed;
Sleep(1500);
}
}

void Draw(HDC hdc,RECT* prc) {
     HDC hdcBuffer=CreateCompatibleDC(hdc);
     HBITMAP hbmBuffer=CreateCompatibleBitmap(hdc,prc->right, prc->bottom);
     HBITMAP hbmOldBuffer=(HBITMAP)SelectObject(hdcBuffer,hbmBuffer);
     HDC hdcMem = CreateCompatibleDC(hdc);
     FillRect(hdcBuffer,prc,(HBRUSH)GetStockObject(WHITE_BRUSH));
     HBITMAP hbmOld;
     BITMAP bm;
     GetObject(bakgrund,sizeof(bm),&bm);
     SelectObject(hdcMem,bakgrund);
     BitBlt(hdcBuffer,0,0,bm.bmWidth,bm.bmHeight,hdcMem,0,0,SRCCOPY);
     for(int i=0; i<2; i++) {
     SelectObject(hdcMem,paddel[i].biten);
     BitBlt(hdcBuffer,paddel[i].x,paddel[i].y,paddel[i].width,paddel[i].height,hdcMem,0,0,SRCCOPY);
     }
     
     SelectObject(hdcMem,boll.masken);
     BitBlt(hdcBuffer,boll.x,boll.y,boll.width,boll.height,hdcMem,0,0,SRCAND);
     SelectObject(hdcMem,boll.biten);
     BitBlt(hdcBuffer,boll.x,boll.y,boll.width,boll.height,hdcMem,0,0,SRCPAINT);
     
     HFONT hfOld=(HFONT)SelectObject(hdcBuffer,g_hfFont);
     SetBkColor(hdcBuffer,RGB(0,0,0));
     SetTextColor(hdcBuffer,RGB(0,255,0));
     SetBkMode(hdcBuffer,TRANSPARENT);
     char player1[30]="Player 1: ";
     char player2[30]="Player 2: ";
     char temp[10];
     stringstream ss;
     ss << padd1score;
     ss >> temp;
     strcat(player1,temp);
     stringstream ss2;
     ss2 << padd2score;
     ss2 >> temp;
     strcat(player2,temp);
     
     TextOut(hdcBuffer,200,20,player1,strlen(player1));
     TextOut(hdcBuffer,300,20,player2,strlen(player2));
     
     BitBlt(hdc,0,0,prc->right,prc->bottom,hdcBuffer,0,0,SRCCOPY);
     SelectObject(hdcMem,hbmOld);
     DeleteDC(hdcMem);
     SelectObject(hdcBuffer,hbmOldBuffer);
     DeleteDC(hdcBuffer);
     DeleteObject(hbmBuffer);
}

void UpdateBall() {
     boll.y+=boll.dy;
     boll.x+=boll.dx;
}

void UpdateComputer(int i) {
     if(paddel[i].y+(paddel[i].height/2)>boll.y+(boll.height/2))
     paddel[i].y-=paddel[i].speed;
     else if(paddel[i].y+(paddel[i].height/2)<boll.y+(boll.height/2))
     paddel[i].y+=paddel[i].speed;
}
